# Build a Custom GAN Model
GANs consist of two networks constantly competing with each other:

  - Generator network that tries to generate data based on the data it was trained on.
  - Discriminator network that is trained to differentiate between real data and data which is created by the generator.

<img width="1291" alt="gan" src="https://user-images.githubusercontent.com/45710599/136113565-d5830e31-bdc5-49ea-8bd5-1e927bca4a66.png">

## How the GAN Model Works

The model consists of two networks, a generator and a discriminator (critic). These two networks work in a tight loop:

  - The generator takes in a batch of single-track piano rolls (melody) as the input and generates a batch of multi-track piano rolls as the output by adding accompaniments to each of the input music tracks.
  - The discriminator evaluates the generated music tracks and predicts how far they deviate from the real data in the training dataset.
  - The feedback from the discriminator is used by the generator to help it produce more realistic music the next time.
  - As the generator gets better at creating better music and fooling the discriminator, the discriminator needs to be retrained by using music tracks just generated by the generator as fake inputs and an equivalent number of songs from the original dataset as the real input.
  - We alternate between training these two networks until the model converges and produces realistic music.

The discriminator is a **binary classifier** which means that it classifies inputs into two groups, e.g. “real” or “fake” data.
